# UnionID API

## 用户信息

UnionID提供基本的用户信息查询接口。

### 1 获取授权用户帐号信息

#### 1.1 API Endpoint

GET https://api.chinauos.com/v1/user

#### 3.2 Request Parameters

**OAuth2 Scope：**

```text
user:read
```

**Header Parameter：**

| 参数名称          | 描述        |
|----------------  |-------------|
| **Authorization** | 用户通过oauth授权获得的token,使用Bearer Token 格式， “Bearer access—token“ |

**Example：**

```bash
curl -v -H "Authorization:Bearer OWNjN2QyMTMt" https://api.chinauos.com/v1/user
```

#### 3.3 Response

| 参数名称          | 描述        |
|----------------  |-------------|
| **username** | 用户名 |
| **nickname** | 呢称 |
| **email** | 邮箱 |
| **profile_image** | 用户大头像 |

**Return 200 and user info when user is exist:**

```http
HTTP/1.1 200 OK
Content-Type: application/json; charset=utf-8

{
    "uid": 17898,
    "username": "Iceyer",
    "nickname": "Iceyer",
    "email": "iceyers@gmail.com",
    "scope": "base,user:read",
    "avatar": "http://u.deepin.org/ucenter_server/avatar.php?uid=17898&size=small",
    "profile_image": "http://u.deepin.org/ucenter_server/avatar.php?uid=17898"
}
```
